#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <fun>
#include <zombieplague>

#define VERSION "1.2"

new const zclass_name[] = { "Headcrab" }
new const zclass_info[] = { "Small and fast" }
new const zclass_model[] = { "headcrabme_t" }
new const zclass_clawmodel[] = { "headcrab_t_knife.mdl" }
const zclass_health = 410
const zclass_speed = 700
const Float:zclass_gravity = 0.65
const Float:zclass_knockback = 2.5

new g_zclass_crab
new g_headcrab[33][2]

public plugin_precache()
{
	g_zclass_crab = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)	
}
public plugin_init()
{	
	register_plugin("[ZP] Headcrab zombie", VERSION, "aaarnas")
	register_cvar("zp_headcrab_version", VERSION, FCVAR_SERVER|FCVAR_SPONLY)
	set_cvar_string("zp_headcrab_version", VERSION)
	RegisterHam(Ham_Spawn, "player", "FwdHamPlayerSpawnPost")
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled")
}
public client_connect(id)
{
	g_headcrab[id][0] = false
	g_headcrab[id][1] = false
}	
public client_disconnect(id)
{
	g_headcrab[id][0] = false
	g_headcrab[id][1] = false
	set_pev(id, pev_bInDuck, 0)
	client_cmd(id, "-duck")
}
public FwdHamPlayerSpawnPost(id)
{
	if(g_headcrab[id][0]) {
		g_headcrab[id][0] = false
		set_user_hitzones(0, id, 255)
		set_pev(id, pev_bInDuck, 0)
		client_cmd(id, "-duck")
	}
	if(g_headcrab[id][1]) {
		set_user_hitzones(0, id, 255)
		g_headcrab[id][1] = false
	}
}
public fw_PlayerKilled(id)
{
	if(g_headcrab[id][0]) {
		g_headcrab[id][0] = false
		set_user_hitzones(0, id, 255)
		client_cmd(id, "cl_forwardspeed 400; cl_backspeed 400; cl_sidespeed 400")
		set_pev(id, pev_bInDuck, 0)
		client_cmd(id, "-duck")
	}
}

public zp_user_infect_attempt(id) {
	
	if(is_user_bot(id))
		zp_set_user_zombie_class(id, 0)
}
public zp_user_infected_post(id, infector, nemesis)
{		
	if(zp_get_user_zombie_class(id) == g_zclass_crab && !nemesis) {
		client_cmd(id, "speak sound/headcrab/hc_headbite")
		g_headcrab[id][0] = true
		g_headcrab[id][1] = true
		client_cmd(id, "cl_forwardspeed 2000; cl_backspeed 2000; cl_sidespeed 2000")
		set_pev(id, pev_bInDuck, 1)
		console_cmd(id, "+duck")
		set_user_hitzones(0, id, 200)
		set_user_footsteps(id, 1)
	}
	else if(zp_get_user_zombie_class(id) == g_zclass_crab) {
		g_headcrab[id][0] = false
		set_user_hitzones(0, id, 255)
		set_pev(id, pev_bInDuck, 0)
		client_cmd(id, "-duck")
	}
	else g_headcrab[id][0] = false
}
public zp_user_humanized_post(id)
{
	g_headcrab[id][0] = false
	set_user_hitzones(0, id, 255)
	client_cmd(id, "cl_forwardspeed 400; cl_backspeed 400; cl_sidespeed 400")
	set_pev(id, pev_bInDuck, 0)
	client_cmd(id, "-duck")
}
public client_PreThink(id)
{
	if(g_headcrab[id][0]) {
		set_pev(id, pev_bInDuck, 1)
		console_cmd(id, "+duck")
	}
}
